<?php

namespace App\Http\Controllers;

use App\Models\Admin;
use App\Http\Requests\StoreAdminRequest;
use App\Http\Requests\UpdateAdminRequest;
use App\Http\Requests\StoreClientRequest;
use App\Http\Requests\UpdateClientRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Auth;
use Carbon\Carbon;

class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return Admin::all();
    }

public function store(Request $request)
{
    // Create the admin using the request data and hash the password
    $admin = Admin::create([
        "fname" => $request->fname,
        "mname" => $request->mname,
        "lname" => $request->lname,
        "email" => $request->email,
        "phone" => $request->phone,
        "accesslevel" => 1,
        "password" => bcrypt($request->password),  // Hash the password using bcrypt
    ]);

    // Return a successful response with the created admin data
    return response()->json($admin, 201);
}



         // Authenticate Users
     public function authenticate(Request $request){
         $credentials = $request->only('email', 'password');
         if (Auth::guard('Admin')->attempt($credentials)) 
          {
            $user =Auth::guard('Admin')->user();
             return response()->json(['data'=>$user], 200);
          }
          else
          {
             return response()->json(['data'=>'failed'],203);
          }
     }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */


    /**
     * Display the specified resource.
     */
    public function show(Admin $admin)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Admin $admin)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAdminRequest $request, Admin $admin)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Admin $admin)
    {
        //
    }
}
