<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class StudentPromotionMail extends Mailable
{
    use Queueable, SerializesModels;

    public $student;
    public $status;
    public $outstandingBalance;

    public function __construct($student, $status, $outstandingBalance = 0)
    {
        $this->student = $student;
        $this->status = $status;
        $this->outstandingBalance = $outstandingBalance;
    }

    public function build()
    {
        return $this->subject("Student Promotion Notification")
                    ->view('emails.student_promotion');
    }
}
