<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Export extends Model
{
    use HasFactory;

    protected $fillable = [
        'requested_by',
        'gii_version_id',
        'year',
        'type',
        'status',
        'path',
        'error',
        'meta',
    ];

    protected $casts = [
        'meta' => 'array',
        'year' => 'integer',
    ];

    /* --------------------
     | Relationships
     |--------------------*/

    public function requester(): BelongsTo
    {
        return $this->belongsTo(User::class, 'requested_by');
    }

    public function giiVersion(): BelongsTo
    {
        return $this->belongsTo(GiiVersion::class);
    }

    /* --------------------
     | Query scopes
     |--------------------*/

    public function scopeForYear(Builder $query, int $year): Builder
    {
        return $query->where('year', $year);
    }

    public function scopeType(Builder $query, string $type): Builder
    {
        return $query->where('type', $type);
    }

    public function scopeStatus(Builder $query, string $status): Builder
    {
        return $query->where('status', $status);
    }
}
