<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class GiiIndicator extends Model
{
    protected $fillable = [
        'gii_subpillar_id',
        'code',
        'name',
        'unit',
        'periodicity',
        'is_computed',
        'is_active',
        'display_order',
        'meta',
    ];

    protected $casts = [
        'is_computed'  => 'boolean',
        'is_active'    => 'boolean',
        'display_order'=> 'integer',
        'meta'         => 'array',
    ];

    public function subpillar(): BelongsTo
    {
        return $this->belongsTo(GiiSubpillar::class, 'gii_subpillar_id');
    }

    public function formula(): HasOne
    {
        // If you version formulas, you might later want: ->where('is_active', true)
        return $this->hasOne(IndicatorFormula::class, 'gii_indicator_id');
    }

    public function observations(): HasMany
    {
        return $this->hasMany(IndicatorObservation::class, 'gii_indicator_id');
    }

    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true);
    }
}
