<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class IndicatorObservation extends Model
{
    protected $fillable = [
        'gii_indicator_id','submission_id','year','month','value','unit','status','confidence','meta'
    ];

    protected $casts = [
        'meta' => 'array',
        'value' => 'decimal:6',
        'confidence' => 'decimal:2',
    ];

    public function indicator(): BelongsTo
    {
        return $this->belongsTo(GiiIndicator::class, 'gii_indicator_id');
    }

    public function submission(): BelongsTo
    {
        return $this->belongsTo(Submission::class);
    }
}
