<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NationalScore extends Model
{
    protected $fillable = [
        'gii_version_id',
        'year',
        'score',
        'global_rank',
        'regional_rank',
        'meta',
        'status',
    ];

    protected $casts = [
        'meta' => 'array',
        'score' => 'decimal:4',
        'year' => 'integer',
        'global_rank' => 'integer',
        'regional_rank' => 'integer',
    ];

    public function version(): BelongsTo
    {
        return $this->belongsTo(GiiVersion::class, 'gii_version_id');
    }
}
