<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PillarScore extends Model
{
    protected $fillable = ['gii_pillar_id','year','score','meta','status'];

    protected $casts = ['meta' => 'array', 'score' => 'decimal:4', 'year' => 'integer'];

    public function pillar(): BelongsTo
    {
        return $this->belongsTo(GiiPillar::class, 'gii_pillar_id');
    }
}
