<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('raw_records', function (Blueprint $table) {
            $table->id();

            // Link to submission
            $table->foreignId('submission_id')
                ->constrained('submissions')
                ->cascadeOnDelete();

            // Raw payload exactly as received (API / upload / portal)
            $table->json('payload')
                ->comment('Raw unprocessed data payload');

            // Optional deduplication / integrity hash
            $table->string('hash', 128)
                ->nullable()
                ->comment('Optional hash for deduplication or integrity checks');

            // Source metadata (optional but powerful)
            $table->string('source_reference')
                ->nullable()
                ->comment('External reference ID, file row number, or API record ID');

            // Record-level validation state (independent of submission)
            $table->enum('status', ['RAW', 'VALID', 'INVALID'])
                ->default('RAW')
                ->comment('Record-level validation status');

            // Validation / processing notes
            $table->text('notes')
                ->nullable()
                ->comment('Validation or processing notes');

            $table->timestamps();

            // Indexes for performance
            $table->index('submission_id', 'idx_raw_record_submission');
            $table->index('status', 'idx_raw_record_status');
            $table->index('hash', 'idx_raw_record_hash');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('raw_records');
    }
};
