<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('audit_logs', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            $table->string('entity_type', 100)
                ->comment('Model/entity e.g. Submission, IndicatorObservation');

            $table->unsignedBigInteger('entity_id')
                ->comment('ID of the affected entity');

            $table->string('event', 50)
                ->comment('created, updated, validated, approved, rejected, exported');

            $table->json('before')->nullable();
            $table->json('after')->nullable();

            $table->ipAddress('ip_address')->nullable();
            $table->string('user_agent')->nullable();

            $table->text('comment')->nullable();

            $table->timestamps();

            $table->index(['entity_type', 'entity_id'], 'idx_audit_entity');
            $table->index('event', 'idx_audit_event');
            $table->index('user_id', 'idx_audit_user');
            $table->index('created_at', 'idx_audit_time');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('audit_logs');
    }
};
