<?php
// public/docs/index.php

$mdFile = __DIR__ . '/niims-api-docs.md';
if (!file_exists($mdFile)) {
    http_response_code(404);
    echo "API documentation not found.";
    exit;
}

$markdown = file_get_contents($mdFile);
$lastUpdated = date('Y-m-d H:i', filemtime($mdFile));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>NIIMS API Documentation</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- GitHub Markdown CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/github-markdown-css@5/github-markdown.min.css">

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <style>
        :root{
            --bg: #0b1220;
            --panel: rgba(255,255,255,0.06);
            --panel2: rgba(255,255,255,0.09);
            --border: rgba(255,255,255,0.12);
            --text: rgba(255,255,255,0.88);
            --muted: rgba(255,255,255,0.62);
            --brand: #1f7aff;
            --brand2:#00d4ff;
            --good:#22c55e;
            --warn:#f59e0b;
            --shadow: 0 20px 60px rgba(0,0,0,0.45);
        }

        * { box-sizing: border-box; }
        html, body { height: 100%; }
        body{
            margin: 0;
            font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji","Segoe UI Emoji";
            background:
                radial-gradient(1000px 700px at 15% 10%, rgba(31,122,255,0.35), transparent 65%),
                radial-gradient(900px 650px at 85% 15%, rgba(0,212,255,0.25), transparent 60%),
                radial-gradient(900px 650px at 50% 95%, rgba(34,197,94,0.15), transparent 55%),
                var(--bg);
            color: var(--text);
        }

        a { color: inherit; }

        /* Layout */
        .shell{
            display: grid;
            grid-template-columns: 320px 1fr;
            gap: 18px;
            max-width: 1400px;
            margin: 0 auto;
            padding: 18px;
        }

        @media (max-width: 980px){
            .shell{ grid-template-columns: 1fr; }
            .sidebar{ position: relative !important; top: 0 !important; }
        }

        /* Top bar */
        .topbar{
            grid-column: 1 / -1;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 14px 16px;
            border: 1px solid var(--border);
            background: linear-gradient(180deg, var(--panel2), var(--panel));
            border-radius: 16px;
            box-shadow: var(--shadow);
            backdrop-filter: blur(10px);
        }
        .brand{
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .logo{
            width: 40px;
            height: 40px;
            border-radius: 12px;
            background: linear-gradient(135deg, var(--brand), var(--brand2));
            display: grid;
            place-items: center;
            box-shadow: 0 12px 30px rgba(31,122,255,0.25);
        }
        .brand h1{
            font-size: 14px;
            margin: 0;
            font-weight: 700;
            letter-spacing: 0.2px;
        }
        .brand p{
            margin: 0;
            font-size: 12px;
            color: var(--muted);
        }
        .top-actions{
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .pill{
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 12px;
            border-radius: 999px;
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.06);
            color: var(--text);
            font-size: 12px;
            text-decoration: none;
            transition: transform .12s ease, background .12s ease;
            user-select: none;
        }
        .pill:hover{ transform: translateY(-1px); background: rgba(255,255,255,0.10); }

        /* Sidebar */
        .sidebar{
            position: sticky;
            top: 18px;
            align-self: start;
            border: 1px solid var(--border);
            background: linear-gradient(180deg, var(--panel2), var(--panel));
            border-radius: 16px;
            box-shadow: var(--shadow);
            backdrop-filter: blur(10px);
            overflow: hidden;
        }
        .sidebar-header{
            padding: 16px;
            border-bottom: 1px solid var(--border);
        }
        .search{
            display: flex;
            gap: 10px;
            align-items: center;
            padding: 10px 12px;
            border-radius: 12px;
            border: 1px solid var(--border);
            background: rgba(0,0,0,0.18);
        }
        .search i{ color: var(--muted); }
        .search input{
            width: 100%;
            border: none;
            outline: none;
            background: transparent;
            color: var(--text);
            font-size: 13px;
        }
        .toc{
            max-height: calc(100vh - 220px);
            overflow: auto;
            padding: 10px 6px 14px 6px;
        }
        .toc a{
            display: block;
            padding: 10px 12px;
            margin: 4px 8px;
            border-radius: 12px;
            text-decoration: none;
            font-size: 13px;
            color: var(--text);
            border: 1px solid transparent;
            transition: background .12s ease, border-color .12s ease;
        }
        .toc a small{
            color: var(--muted);
            display: block;
            font-size: 11px;
            margin-top: 2px;
        }
        .toc a:hover{
            background: rgba(255,255,255,0.08);
            border-color: rgba(255,255,255,0.10);
        }
        .toc a.active{
            background: rgba(31,122,255,0.18);
            border-color: rgba(31,122,255,0.35);
        }

        /* Content */
        .content{
            border: 1px solid var(--border);
            background: linear-gradient(180deg, rgba(255,255,255,0.06), rgba(255,255,255,0.04));
            border-radius: 16px;
            box-shadow: var(--shadow);
            backdrop-filter: blur(10px);
            overflow: hidden;
        }

        .content-head{
            padding: 16px 18px;
            border-bottom: 1px solid var(--border);
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
        }

        .meta{
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            color: var(--muted);
            font-size: 12px;
            align-items: center;
        }
        .badge{
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 10px;
            border-radius: 999px;
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.06);
            color: var(--text);
            font-size: 12px;
        }

        .btn{
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 12px;
            border-radius: 12px;
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.06);
            color: var(--text);
            text-decoration: none;
            font-size: 12px;
            cursor: pointer;
            transition: transform .12s ease, background .12s ease;
        }
        .btn:hover{ transform: translateY(-1px); background: rgba(255,255,255,0.10); }
        .btn.primary{
            background: linear-gradient(135deg, rgba(31,122,255,0.85), rgba(0,212,255,0.55));
            border-color: rgba(31,122,255,0.35);
        }

        /* Markdown overrides */
        .markdown-wrap{
            padding: 22px 22px 30px 22px;
        }
        .markdown-body{
            background: transparent !important;
            color: var(--text);
            font-size: 15px;
            line-height: 1.7;
        }
        .markdown-body h1,
        .markdown-body h2,
        .markdown-body h3,
        .markdown-body h4{
            color: rgba(255,255,255,0.94);
            border-bottom: 1px solid rgba(255,255,255,0.12);
            padding-bottom: .35em;
        }
        .markdown-body p,
        .markdown-body li{
            color: var(--text);
        }
        .markdown-body hr{
            border-color: rgba(255,255,255,0.12);
        }
        .markdown-body code{
            background: rgba(255,255,255,0.08);
            border: 1px solid rgba(255,255,255,0.10);
            border-radius: 8px;
            padding: 2px 6px;
            color: rgba(255,255,255,0.92);
        }
        .markdown-body pre{
            background: rgba(0,0,0,0.35) !important;
            border: 1px solid rgba(255,255,255,0.12);
            border-radius: 14px;
            padding: 14px;
            overflow: auto;
        }
        .markdown-body pre code{
            border: none;
            background: transparent;
            padding: 0;
        }
        .markdown-body table{
            width: 100%;
            border-collapse: collapse;
            border: 1px solid rgba(255,255,255,0.12);
            border-radius: 14px;
            overflow: hidden;
        }
        .markdown-body table th,
        .markdown-body table td{
            border-color: rgba(255,255,255,0.12) !important;
            background: rgba(255,255,255,0.03);
            color: var(--text);
        }
        .markdown-body blockquote{
            border-left: 4px solid rgba(31,122,255,0.55);
            background: rgba(31,122,255,0.08);
            padding: 10px 14px;
            border-radius: 12px;
            color: var(--text);
        }

        /* Small footer */
        .footer{
            padding: 14px 18px;
            border-top: 1px solid var(--border);
            color: var(--muted);
            font-size: 12px;
            display: flex;
            justify-content: space-between;
            gap: 10px;
            flex-wrap: wrap;
        }
        .footer a{ color: rgba(255,255,255,0.75); text-decoration: none; }
        .footer a:hover{ text-decoration: underline; }
    </style>
</head>
<body>

<div class="shell">
    <div class="topbar">
        <div class="brand">
            <div class="logo" aria-hidden="true">
                <i class="bi bi-bar-chart-line-fill"></i>
            </div>
            <div>
                <h1>NIIMS API Documentation</h1>
                <p>National Innovation Intelligence and Measurement System</p>
            </div>
        </div>

        <div class="top-actions">
            <span class="pill"><i class="bi bi-clock"></i> Updated: <?= htmlspecialchars($lastUpdated) ?></span>
            <a class="pill" href="niims-api-docs.md" target="_blank" rel="noopener">
                <i class="bi bi-filetype-md"></i> Open .md
            </a>
            <button class="pill" id="copyBaseUrl">
                <i class="bi bi-clipboard"></i> Copy Base URL
            </button>
        </div>
    </div>

    <!-- Sidebar -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="search">
                <i class="bi bi-search"></i>
                <input id="tocSearch" type="text" placeholder="Search sections..." autocomplete="off" />
            </div>
        </div>
        <nav class="toc" id="toc"></nav>
    </aside>

    <!-- Main content -->
    <main class="content">
        <div class="content-head">
            <div class="meta">
                <span class="badge"><i class="bi bi-shield-lock"></i> Sanctum Protected</span>
                <span class="badge"><i class="bi bi-diagram-3"></i> GII Taxonomy and Submissions</span>
                <span class="badge"><i class="bi bi-activity"></i> Audit-grade logs</span>
            </div>

            <div style="display:flex; gap:10px; align-items:center;">
                <button class="btn" id="expandAll"><i class="bi bi-arrows-angle-expand"></i> Expand Headings</button>
                <button class="btn primary" id="scrollTop"><i class="bi bi-arrow-up"></i> Top</button>
            </div>
        </div>

        <div class="markdown-wrap">
            <article class="markdown-body" id="content"></article>
        </div>

        <div class="footer">
            <span>(c) <?= date('Y') ?> NIIMS - Government-grade innovation intelligence</span>
            <span>
                <a href="niims-api-docs.md" target="_blank" rel="noopener">Download Markdown</a>
            </span>
        </div>
    </main>
</div>

<!-- Markdown parser -->
<script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>

<script>
    // Render markdown
    const markdown = <?= json_encode($markdown) ?>;
    const contentEl = document.getElementById('content');
    contentEl.innerHTML = marked.parse(markdown);

    // Build TOC from headings
    const tocEl = document.getElementById('toc');
    const headings = contentEl.querySelectorAll('h1, h2, h3');
    const tocItems = [];

    function slugify(text){
        return text.toLowerCase()
            .trim()
            .replace(/[^\w\s-]/g, '')
            .replace(/\s+/g, '-');
    }

    headings.forEach(h => {
        if (!h.id) h.id = slugify(h.textContent);
        tocItems.push({
            id: h.id,
            text: h.textContent,
            level: h.tagName
        });
    });

    function renderToc(filter = ''){
        tocEl.innerHTML = '';
        const f = filter.trim().toLowerCase();
        tocItems
            .filter(item => !f || item.text.toLowerCase().includes(f))
            .forEach(item => {
                const a = document.createElement('a');
                a.href = `#${item.id}`;
                a.dataset.target = item.id;
                a.innerHTML = `${item.text}<small>${item.level}</small>`;
                if (item.level === 'H1') a.style.fontWeight = '700';
                if (item.level === 'H2') a.style.paddingLeft = '18px';
                if (item.level === 'H3') a.style.paddingLeft = '30px';
                tocEl.appendChild(a);
            });
    }
    renderToc();

    // Active section highlight on scroll
    const tocLinks = () => tocEl.querySelectorAll('a');
    function setActive(id){
        tocLinks().forEach(a => a.classList.toggle('active', a.dataset.target === id));
    }

    const observer = new IntersectionObserver((entries) => {
        const visible = entries.filter(e => e.isIntersecting).sort((a,b)=>b.intersectionRatio-a.intersectionRatio)[0];
        if (visible) setActive(visible.target.id);
    }, { rootMargin: "-30% 0px -60% 0px", threshold: [0.05, 0.1, 0.2, 0.4, 0.6] });

    headings.forEach(h => observer.observe(h));

    // Search TOC
    document.getElementById('tocSearch').addEventListener('input', (e) => {
        renderToc(e.target.value);
    });

    // Buttons
    document.getElementById('scrollTop').addEventListener('click', () => {
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });

    document.getElementById('copyBaseUrl').addEventListener('click', async () => {
        const base = window.location.origin;
        try{
            await navigator.clipboard.writeText(base);
            alert('Copied: ' + base);
        }catch(e){
            prompt('Copy Base URL:', base);
        }
    });

    // Expand headings: focus search to quickly jump
    document.getElementById('expandAll').addEventListener('click', () => {
        document.getElementById('tocSearch').focus();
    });
</script>

</body>
</html>
