# National Innovation Intelligence & Measurement System (NIIMS)
## Backend API Documentation (with Examples)

**Base URL**
```
https://api.yourdomain.com
```

**Routing note**
- The GII/NIIMS endpoints documented here are registered in `routes/web.php` (no `/api` prefix).
- Knowledge/AI endpoints (if enabled) live under `/api` in `routes/api.php`.

## Authentication
All endpoints (unless you decide otherwise) are protected with **Laravel Sanctum**.

**Headers**
```
Authorization: Bearer {token}
Accept: application/json
Content-Type: application/json
```

**Example (curl)**
```bash
curl -X GET "https://api.yourdomain.com/gii-versions" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

---

## Common Response Shape
Most endpoints follow this structure:

```json
{
  "message": "Human friendly message",
  "data": {}
}
```

For paginated lists, `data` is usually a Laravel paginator structure:
```json
{
  "message": "Retrieved successfully.",
  "data": {
    "current_page": 1,
    "data": [],
    "per_page": 15,
    "total": 0
  }
}
```

---

# 1) GII Versions

## 1.1 List versions
**GET** `/gii-versions?per_page=15`

**Example**
```bash
curl -X GET "https://api.yourdomain.com/gii-versions?per_page=10" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

**Example Response**
```json
{
  "message": "GII versions retrieved successfully.",
  "data": {
    "current_page": 1,
    "data": [
      { "id": 1, "year": "2025", "name": "GII 2025", "is_active": true, "created_at": "...", "updated_at": "..." }
    ],
    "per_page": 10,
    "total": 1
  }
}
```

## 1.2 View one version
**GET** `/gii-versions/{id}`

```bash
curl -X GET "https://api.yourdomain.com/gii-versions/1" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

## 1.3 Create version
**POST** `/gii-versions`

**Body**
```json
{
  "year": "2026",
  "name": "GII 2026"
}
```

**curl**
```bash
curl -X POST "https://api.yourdomain.com/gii-versions" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json" \
  -H "Content-Type: application/json" \
  -d '{"year":"2026","name":"GII 2026"}'
```

## 1.4 Update version
**PUT** `/gii-versions/{id}`

**Body**
```json
{
  "name": "GII 2026 (Updated)"
}
```

## 1.5 Activate version (only one active)
**PATCH** `/gii-versions/{id}/activate`

```bash
curl -X PATCH "https://api.yourdomain.com/gii-versions/2/activate" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

---

# 2) GII Pillars

## 2.1 List pillars
**GET** `/gii-pillars?gii_version_id=&is_active=&per_page=`

**Example**
```bash
curl -X GET "https://api.yourdomain.com/gii-pillars?gii_version_id=1&is_active=1" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

## 2.2 View pillar
**GET** `/gii-pillars/{id}`

## 2.3 Create pillar
**POST** `/gii-pillars`

**Body**
```json
{
  "gii_version_id": 1,
  "pillar_number": 1,
  "code": "P1",
  "name": "Institutions",
  "description": "Institutional environment pillar",
  "display_order": 1
}
```

## 2.4 Update pillar
**PUT** `/gii-pillars/{id}`

**Body**
```json
{
  "name": "Institutions (Updated)",
  "display_order": 1,
  "is_active": true
}
```

## 2.5 Toggle pillar active
**PATCH** `/gii-pillars/{id}/toggle`

---

# 3) GII Subpillars

## 3.1 List subpillars
**GET** `/gii-subpillars?gii_pillar_id=&is_active=&per_page=`

**Example**
```bash
curl -X GET "https://api.yourdomain.com/gii-subpillars?gii_pillar_id=1" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

## 3.2 View subpillar
**GET** `/gii-subpillars/{id}`

## 3.3 Create subpillar
**POST** `/gii-subpillars`

**Body**
```json
{
  "gii_pillar_id": 1,
  "code": "1.1",
  "name": "Political environment",
  "description": "Governance and stability indicators",
  "display_order": 1
}
```

## 3.4 Update subpillar
**PUT** `/gii-subpillars/{id}`

## 3.5 Toggle subpillar active
**PATCH** `/gii-subpillars/{id}/toggle`

---

# 4) GII Indicators

## 4.1 List indicators
**GET** `/gii-indicators?gii_subpillar_id=&code=&periodicity=&is_active=&per_page=`

**Example**
```bash
curl -X GET "https://api.yourdomain.com/gii-indicators?gii_subpillar_id=1&periodicity=yearly" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

## 4.2 View indicator
**GET** `/gii-indicators/{id}`

## 4.3 Create indicator
**POST** `/gii-indicators`

**Body**
```json
{
  "gii_subpillar_id": 1,
  "code": "1.1.1",
  "name": "Political Stability Index",
  "unit": "index",
  "periodicity": "yearly",
  "is_computed": false,
  "display_order": 1,
  "meta": {
    "definition": "Index describing political stability",
    "source_hint": "ZIMSTAT / OPC / World Bank"
  }
}
```

## 4.4 Update indicator
**PUT** `/gii-indicators/{id}`

**Body**
```json
{
  "unit": "%",
  "meta": { "definition": "Updated definition" }
}
```

## 4.5 Toggle indicator active
**PATCH** `/gii-indicators/{id}/toggle`

---

# 5) Indicator Formulas

## 5.1 List formulas
**GET** `/indicator-formulas?gii_indicator_id=&is_active=&per_page=`

## 5.2 View formula
**GET** `/indicator-formulas/{id}`

## 5.3 Create formula (versioned; auto-deactivates old active)
**POST** `/indicator-formulas`

**Body**
```json
{
  "gii_indicator_id": 1,
  "formula_type": "expression",
  "formula": "(a + b) / c",
  "params": { "a": "var1", "b": "var2", "c": "var3" }
}
```

**Example Response**
```json
{
  "message": "Indicator formula created successfully.",
  "data": {
    "id": 10,
    "gii_indicator_id": 1,
    "formula_type": "expression",
    "formula": "(a + b) / c",
    "params": { "a": "var1", "b": "var2", "c": "var3" },
    "version": 2,
    "is_active": true
  }
}
```

## 5.4 Update formula (allowed, but versioning is recommended)
**PUT** `/indicator-formulas/{id}`

## 5.5 Activate a formula version
**PATCH** `/indicator-formulas/{id}/activate`

---

# 6) Institutions

## 6.1 List institutions
**GET** `/institutions?type=&is_active=&per_page=`

**Example**
```bash
curl -X GET "https://api.yourdomain.com/institutions?type=agency&is_active=1" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

## 6.2 View institution
**GET** `/institutions/{id}`

## 6.3 Create institution
**POST** `/institutions`

**Body**
```json
{
  "name": "ZIMSTAT",
  "type": "agency",
  "code": "ZIMSTAT",
  "email": "info@zimstat.co.zw",
  "phone": "+263-...",
  "address": "Harare, Zimbabwe"
}
```

## 6.4 Update institution
**PUT** `/institutions/{id}`

## 6.5 Toggle institution active
**PATCH** `/institutions/{id}/toggle`

---

# 7) Submissions (Data Ingestion + Workflow)

## 7.1 List submissions
**GET** `/submissions?status=&year=&institution_id=&per_page=`

**Example**
```bash
curl -X GET "https://api.yourdomain.com/submissions?year=2025&status=SUBMITTED" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

## 7.2 View submission (loads files, raw records, approvals)
**GET** `/submissions/{id}`

## 7.3 Create submission
**POST** `/submissions`

**Body**
```json
{
  "institution_id": 1,
  "gii_indicator_id": 5,
  "year": 2025,
  "month": 6,
  "source": "portal",
  "notes": "Annual report data submission"
}
```

## 7.4 Add raw record to submission
**POST** `/submissions/{id}/raw-records`

**Body**
```json
{
  "payload": { "value": 42, "country": "ZW" },
  "hash": "optional-hash",
  "source_reference": "row-1021",
  "status": "RAW",
  "notes": "Imported from CSV batch"
}
```

## 7.5 Upload submission file (multipart/form-data)
**POST** `/submissions/{id}/files`

**Fields**
- `file` required
- `file_type` optional (`evidence`, `dataset`, `report`, `annex`)

**curl**
```bash
curl -X POST "https://api.yourdomain.com/submissions/12/files" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json" \
  -F "file=@/path/to/evidence.pdf" \
  -F "file_type=evidence"
```

---

## Workflow Endpoints

### Submit
**POST** `/submissions/{id}/submit`

### Validate
**POST** `/submissions/{id}/validate`

### Approve
**POST** `/submissions/{id}/approve`

### Publish
**POST** `/submissions/{id}/publish`

### Reject
**POST** `/submissions/{id}/reject`

**Body**
```json
{ "reason": "Data incomplete or inconsistent." }
```

---

# 8) Submission Files

## 8.1 List submission files
**GET** `/submission-files?submission_id=&file_type=&uploaded_by=&per_page=`

## 8.2 Upload submission file (multipart/form-data)
**POST** `/submission-files`

**Fields**
- `submission_id` required
- `file` required
- `file_type` optional (`evidence`, `dataset`, `report`, `annex`)

## 8.3 View submission file
**GET** `/submission-files/{id}`

## 8.4 Update submission file metadata
**PUT** `/submission-files/{id}`

**Body**
```json
{
  "file_type": "report",
  "original_name": "final-report.pdf",
  "checksum": "sha256..."
}
```

## 8.5 Delete submission file
**DELETE** `/submission-files/{id}`

---

# 9) Raw Records

## 9.1 List raw records
**GET** `/raw-records?submission_id=&status=&hash=&source_reference=&per_page=`

## 9.2 Create raw record
**POST** `/raw-records`

**Body**
```json
{
  "submission_id": 12,
  "payload": { "value": 123.4, "unit": "index" },
  "hash": "optional-hash",
  "source_reference": "row-98",
  "status": "RAW",
  "notes": "Imported from XLSX"
}
```

## 9.3 View raw record
**GET** `/raw-records/{id}`

## 9.4 Update raw record
**PUT** `/raw-records/{id}`

## 9.5 Delete raw record
**DELETE** `/raw-records/{id}`

---

# 10) Indicator Observations

## 10.1 List observations
**GET** `/indicator-observations?gii_indicator_id=&submission_id=&year=&status=&per_page=`

## 10.2 Create observation
**POST** `/indicator-observations`

**Body**
```json
{
  "gii_indicator_id": 5,
  "submission_id": 12,
  "year": 2025,
  "month": 6,
  "value": 47.25,
  "unit": "index",
  "status": "APPROVED",
  "confidence": 90,
  "meta": { "source": "portal" }
}
```

## 10.3 View observation
**GET** `/indicator-observations/{id}`

## 10.4 Update observation
**PUT** `/indicator-observations/{id}`

## 10.5 Delete observation
**DELETE** `/indicator-observations/{id}`

---

# 11) Analytics + Scores

## 11.1 Compute analytics for a year
**POST** `/analytics/{year}/compute`

## 11.2 Pillar scores by year
**GET** `/analytics/{year}/pillar-scores`

## 11.3 National score by year
**GET** `/analytics/{year}/national-score`

## 11.4 List pillar scores
**GET** `/pillar-scores?gii_pillar_id=&year=&status=&per_page=`

## 11.5 Create pillar score
**POST** `/pillar-scores`

**Body**
```json
{
  "gii_pillar_id": 3,
  "year": 2025,
  "score": 45.12,
  "status": "APPROVED",
  "meta": { "method": "avg-approved-observations" }
}
```

## 11.6 Update pillar score
**PUT** `/pillar-scores/{id}`

## 11.7 Delete pillar score
**DELETE** `/pillar-scores/{id}`

## 11.8 List national scores
**GET** `/national-scores?gii_version_id=&year=&status=&per_page=`

## 11.9 Create national score
**POST** `/national-scores`

**Body**
```json
{
  "gii_version_id": 1,
  "year": 2025,
  "score": 49.01,
  "global_rank": 98,
  "regional_rank": 12,
  "status": "APPROVED",
  "meta": { "method": "avg-pillar-scores" }
}
```

## 11.10 Update national score
**PUT** `/national-scores/{id}`

## 11.11 Delete national score
**DELETE** `/national-scores/{id}`

---

# 12) Exports (WIPO / Internal)

## 12.1 List exports
**GET** `/exports?year=&type=&status=&per_page=`

## 12.2 Create export request
**POST** `/exports`

**Body**
```json
{
  "gii_version_id": 1,
  "year": 2025,
  "type": "wipo"
}
```

## 12.3 Generate export (sync example)
**POST** `/exports/{id}/generate`

## 12.4 Download export file
**GET** `/exports/{id}/download`

---

# 13) Approval Actions

## 13.1 List approval actions
**GET** `/approval-actions?submission_id=&action=&acted_by=&per_page=`

## 13.2 View approval action
**GET** `/approval-actions/{id}`

---

# 14) Audit Logs (System-wide)
Audit logs are written on list, view, create, update, toggle, workflow, and download actions.

Typical fields:
- `user_id`
- `entity_type`
- `entity_id`
- `event`
- `before` (JSON)
- `after` (JSON)
- `ip_address`
- `user_agent`
- `comment`
- `created_at`

---

## Status Codes
- `200` OK
- `201` Created
- `401` Unauthorized
- `403` Forbidden
- `404` Not Found
- `422` Validation / Workflow Error
- `500` Server Error

---

NIIMS - Government-Grade Innovation Intelligence Platform
