<!DOCTYPE html>
<html>
<head>
    <title>Certificate Collection Application</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .email-container {
            background-color: #ffffff;
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            border-radius: 8px;
            box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #003366;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: bold;
        }
        .content {
            padding: 20px;
            color: #333333;
        }
        .content h1 {
            color: #003366;
            font-size: 22px;
        }
        .content p {
            line-height: 1.6;
        }
        .content a {
            color: #007bff;
            text-decoration: none;
        }
        .content a:hover {
            text-decoration: underline;
        }
        .footer {
            background-color: #003366;
            color: white;
            padding: 10px;
            text-align: center;
            border-radius: 0 0 8px 8px;
        }
        .footer p {
            margin: 0;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header Section -->
        <div class="header">
            <h1>Online Certificate Application</h1>
        </div>

        <!-- Body Content -->
        <div class="content">
            <h1>Hello {{ $name }},</h1>
            <p>
                We are pleased to inform you that your application for certificate collection has been successfully submitted.
            </p>
            <p>
                Our team will review your request, and you will be notified once your certificate is ready for collection.
            </p>
            <p>
                You can <a href="https://jv.arda.co.zw/jv/search.html" target="_blank">click here</a> to check the status of your application at any time.
            </p>
            <p>
                Thank you for choosing us!
            </p>
        </div>

        <!-- Footer Section -->
        <div class="footer">
            <p>Best regards,<br>BINDURA UNIVERSITY OF SCIENCE EDUCATION</p>
            <p>&copy; 2024 BUSE</p>
        </div>
    </div>
</body>
</html>
